function [responders,responderstraces] = slopefunction(timetraces,celllabel,xaxis);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Defines the activators from the traces that have a shift between to
%%% subsequent frames that is greater than the set threshold

%%% Requires plotheatmapfunction in the same folder

%%% INPUT ARGUMENTS:

%%% timetraces: matrix with the timetraces to analyze (1col = 1cell)
%%% celllabel: each row contains cell number-X-Y
%%% xaxis: col with the actual times, to use as x axis

%%% Example of a string: 'MFI/MFI_{0} of single cells'

%%% OUTPUT ARGUMENTS:

%%% responders: each row contains cell number-X-Y of the responders
%%% 'ResultsSlope.csv' file in the directory
%%% responderstraces: time traces of the responders

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Asks for manual input of time span and shift

prompt = 'How many frames apart to consider?\n';
nframe = input(prompt);
prompt = 'What is the threshold shift between two N frames?\n';
threshold = input(prompt);

%%% Defines

ii=0;
jj=0;
zz=1;

for ii=1:size(timetraces,2) % for all the cells (cols)
    for jj=(1+nframe):size(timetraces,1) % for all the frames (rows) starting from (1+nframe)
        if abs(timetraces(jj,ii)-timetraces(jj-nframe,ii)) > threshold 
            responders(zz)=celllabel(ii);
            respondersnumber(zz)=ii;
            zz=zz+1;
            break
        end
    end
end

responderstraces = timetraces(:,respondersnumber); %recalls top traces
responderstracest = responderstraces'; %%% Creates transposts for colormap representation

%%% Creates TopResults.csv

position = [];
ii=0;
for ii=1:numel(responders)
    aa = find(celllabel(:,1)==responders(ii));
   position(ii,:) = celllabel(aa,:);
end

position(:,1) = []; %gets rid of cell name column

csvwrite('ResultsSlope.csv',position,1,0);

name1 = 'ResultsSlope.csv';
    tmp1 = csvread(name1,1,0);
    X = tmp1(:,1);
    Y = tmp1(:,2);
    T1 = table(X,Y);
    writetable(T1,name1,'Delimiter',',','QuoteStrings',true);
    
responders = [responders' position];

%%% Plot responders' time traces and heatmap

plotheatmapfunction('Responsive cells (slope method)','Responsive cells, heatmap (slope method)','Time (s)','MFI','Frames','Stack of responders',responderstraces,xaxis);

end
